/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.udp;

import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.impl.udp.IncomingDatagramPortOwner;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class OutgoingDatagramPortOwner {
    private static final String TRACE_MASKD = "XFCSODPD";
    private static final String TRACE_MASKF = "XFCSODPF";
    private static final String TRACE_MASKT = "XFCSODPT";
    private static OutgoingDatagramPortOwner _singleton;
    private DatagramSocket outSocket;
    private static boolean allowBroadcastOverPublicNetworks;
    private DatagramSocket[] outSockets;
    private boolean useTestCode = false;
    private static MachineId machineId;

    private OutgoingDatagramPortOwner() {
        this.buildSocket();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void buildSocket() {
        boolean deprecated = true;
        if (deprecated) {
            return;
        }
        if (this.useTestCode) {
            try {
                int i;
                if (this.outSockets != null || machineId == null) return;
                int count = 0;
                for (i = 0; i < machineId.getNicAddresses().length; ++i) {
                    if (machineId.getPublicNetworkIndicators()[i] && !allowBroadcastOverPublicNetworks) continue;
                    ++count;
                }
                this.outSockets = new DatagramSocket[count];
                count = 0;
                for (i = 0; i < machineId.getNicAddresses().length; ++i) {
                    if (machineId.getPublicNetworkIndicators()[i] && !allowBroadcastOverPublicNetworks) continue;
                    if (IncomingDatagramPortOwner.isUseMulticast()) {
                        this.outSockets[count] = new MulticastSocket();
                        ((MulticastSocket)this.outSockets[count]).setTimeToLive(5);
                        ((MulticastSocket)this.outSockets[count]).joinGroup(InetAddress.getByName("225.4.5.6"));
                        ((MulticastSocket)this.outSockets[count]).setInterface(machineId.getNicAddresses()[i]);
                    } else {
                        this.outSockets[count] = new DatagramSocket();
                        Trace.trace(TRACE_MASKF, "created new outSocket");
                    }
                    ++count;
                }
                return;
            }
            catch (SocketException se) {
                Trace.trace(TRACE_MASKF, se);
                this.outSockets = null;
                return;
            }
            catch (IOException ioe) {
                Trace.trace(TRACE_MASKF, ioe);
                this.outSockets = null;
                return;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, e);
                this.outSockets = null;
                return;
            }
        }
        try {
            if (this.outSocket != null) return;
            if (IncomingDatagramPortOwner.isUseMulticast()) {
                this.outSocket = new MulticastSocket();
                ((MulticastSocket)this.outSocket).setTimeToLive(5);
                ((MulticastSocket)this.outSocket).joinGroup(InetAddress.getByName("225.4.5.6"));
                ((MulticastSocket)this.outSocket).setInterface(InetAddress.getLocalHost());
                return;
            } else {
                this.outSocket = new DatagramSocket();
            }
            return;
        }
        catch (SocketException se) {
            this.outSocket = null;
            return;
        }
        catch (IOException ioe) {
            this.outSocket = null;
        }
    }

    public static synchronized OutgoingDatagramPortOwner getOutgoingDatagramPortOwner() {
        if (_singleton == null) {
            _singleton = new OutgoingDatagramPortOwner();
        }
        return _singleton;
    }

    public void send(DatagramPacket packet) {
        block8: {
            block7: {
                if (!this.useTestCode) break block7;
                if (this.outSockets == null) {
                    this.buildSocket();
                }
                if (this.outSockets == null) break block8;
                for (int i = 0; i < this.outSockets.length; ++i) {
                    if (this.outSockets[i] == null) continue;
                    try {
                        this.outSockets[i].send(packet);
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                break block8;
            }
            if (this.outSocket == null) {
                this.buildSocket();
            }
            if (this.outSocket == null) break block8;
            try {
                this.outSocket.send(packet);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void closeSocket() {
        if (this.useTestCode) {
            if (this.outSockets != null) {
                for (int i = 0; i < this.outSockets.length; ++i) {
                    try {
                        this.outSockets[i].close();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.outSockets = null;
            }
        } else if (this.outSocket != null) {
            try {
                this.outSocket.close();
                this.outSocket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void restart() {
        if (this.useTestCode) {
            if (this.outSockets == null) {
                this.buildSocket();
            }
        } else if (this.outSocket == null) {
            this.buildSocket();
        }
    }

    public void networkSettingsChanged() {
        this.closeSocket();
        this.buildSocket();
        MachineId tmp = null;
        try {
            tmp = FcsServer.getFcsServer().getLocalMachineId();
            if (tmp != null) {
                machineId = tmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setAllowBroadcastOverPublicNetworks(boolean newVal) {
        Trace.trace(TRACE_MASKF, "setAllowBroadcastOverPublicNetworks(" + newVal + ")");
        if (newVal != allowBroadcastOverPublicNetworks) {
            allowBroadcastOverPublicNetworks = newVal;
            OutgoingDatagramPortOwner.getOutgoingDatagramPortOwner().closeSocket();
            OutgoingDatagramPortOwner.getOutgoingDatagramPortOwner().buildSocket();
        }
    }

    public static void setMachineId(MachineId newMachineId) {
        machineId = newMachineId;
    }
}

